<?php

namespace App\Http\Controllers\Admin;

use App\Models\Shift;
use App\Models\Absensi;
use App\Models\Karyawan;
use App\Models\Departemen;
use App\Models\Notifikasi;
use App\Models\AjukanShift;
use App\Models\JadwalShift;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class JadwalShiftController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $jadwalShift = JadwalShift::all();
        $departemen = Departemen::all();
        $shift = Shift::all();
        return view('admin.jadwal-shift.index', compact('shift', 'jadwalShift', 'departemen'));
    }


        public function store(Request $request)
    {
        try {
        $request->validate([
            'departemen_id'   => 'required|exists:departemen,id',
            'shift_id'        => 'required|exists:shift,id',
            'tanggal_mulai'   => 'required|date',
            'tanggal_selesai' => 'nullable|date|after_or_equal:tanggal_mulai',
        ]);

        JadwalShift::create([
            'departemen_id'   => $request->departemen_id,
            'shift_id'        => $request->shift_id,
            'tanggal_mulai'   => $request->tanggal_mulai,
            'tanggal_selesai' => $request->tanggal_selesai,
            'is_active'       => true,
        ]);

            return redirect()->back()->with('success', 'Jadwal shift berhasil ditambahkan');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal menambahkan jadwal shift!');
        }
    }

    public function update(Request $request, JadwalShift $jadwalShift)
    {
        try {
        $request->validate([
            'departemen_id'   => 'required|exists:departemen,id',
            'shift_id'        => 'required|exists:shift,id',
            'tanggal_mulai'   => 'required|date',
            'tanggal_selesai' => 'nullable|date|after_or_equal:tanggal_mulai',
        ]);

        $jadwalShift->update([
            'departemen_id'   => $request->departemen_id,
            'shift_id'        => $request->shift_id,
            'tanggal_mulai'   => $request->tanggal_mulai,
            'tanggal_selesai' => $request->tanggal_selesai,
        ]);


            return redirect()->back()->with('success', 'Jadwal shift berhasil diperbarui');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Gagal memperbarui jadwal shift!');
        }
    }

    public function destroy(JadwalShift $jadwalShift)
    {
        try {
            $jadwalShift->delete();
            return redirect()->back()->with('success', 'Jadwal shift berhasil dihapus');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Jadwal shift gagal dihapus');
        }
    }

}
